define(['modules/appointments/cancellation/cancellation-control-view'], function(CancellationControlView) {
    'use strict';

    describe('Cancellation Control View', function() {
        var view;
        var $view;

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            view = new CancellationControlView({
                modelType: 'baz',
                elAfterCancellation: $('.element-for-focus'),
            });

            $('body').append('<a class="element-for-focus" href="#"></a>');

            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a Cancel button with the modelType text', function() {
            expect($view.find('button, a[role=button]').length).toEqual(1);

            expect($view.find('.cancel-btn').attr('id')).toEqual('cancel-baz-btn');
            expect($view.find('#cancel-baz-btn').text()).toEqual('Cancel Baz');
        });
    });
});
